﻿using System;
using System.Diagnostics;
using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VIMT.VideoVisit.Messages;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.PipelineSteps.Delete
{
    /// <summary>
    /// Post to Video Visit Service step.
    /// </summary>
    public class PutToVideoVisitServiceStep : FilterBase<VideoVisitDeleteStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VideoVisitDeleteStateObject state)
        {
            if (state.ExceptionOccured) return;
            if (!string.IsNullOrEmpty(state.VistaFakeResponseType)) return;

            try
            {
                var timer = new Stopwatch();
                timer.Start();
                state.CancelAppointmentRequest.VIMTTmpCancelAppointmentRequestDataInfo.SamlToken = state.SamlToken;
                var response = state.CancelAppointmentRequest.SendReceive<VIMTTmpCancelAppointmentResponse>(MessageProcessType.Local);
                timer.Stop();
                state.EcProcessingTimeMs += (int)timer.ElapsedMilliseconds;

                if (response.ExceptionOccured)
                {
                    state.ExceptionOccured = true;
                    state.ExceptionMessage = response.ExceptionMessage;
                }
                else
                {
                    if (response.VIMTTmpCancelAppointmentResponseDataInfo != null)
                    {
                        if (response.VIMTTmpCancelAppointmentResponseDataInfo.HttpStatusCode == "OK")
                        {
                            state.EcResponse = response;
                            return;
                        }
                        state.ExceptionOccured = true;
                        state.ExceptionMessage = string.Format("The Video Visit Cancel Appointment VIMT message failed with HTTP status code {0}", response.VIMTTmpCancelAppointmentResponseDataInfo.HttpStatusCode);
                    }
                    else
                    {
                        state.ExceptionOccured = true;
                        state.ExceptionMessage = "The VIMTTmpCancelAppointmentResponseDataInfo response value is null";
                    }
                }
            }
            catch (Exception ex)
            {
                var exceptionMessage = ex.Message;
                exceptionMessage += PipelineUtilities.BuildErrorMessage(ex);

                state.ExceptionOccured = true;
                state.ExceptionMessage = exceptionMessage;
            }
        }
    }
}